// Drops.h: interface for the CDrops class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_DROPS_H__0DE5BE25_A1A3_4FA3_BC8F_128F194D958A__INCLUDED_)
#define AFX_DROPS_H__0DE5BE25_A1A3_4FA3_BC8F_128F194D958A__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


#define MAX_PICKUP_RANGE	24	// the max range you can "secretly walk" to an item
#define	MAX_SIGHT_RANGE		60	// the max range you can see items in an area
#define	MIN_FORGET_RANGE	92	// the mix range you will forget about an item


// all other drops
class CNormalDrop
{
public:
	char		m_SendMsg[13] ;
	DWORD		m_ItemID ;

	DWORD		m_X ;
	DWORD		m_Y ;
	int			m_Range ;
	int			m_MaxRange ;

	BOOL		m_Valid ;
	BOOL		m_BeenExamined ;
//	BOOL		m_BeenDelayed ;
//	int			m_FailCount ;
} ;


// the uber drop class
class CUberDrop : public CNormalDrop
{
public:
	int			m_DelayRemaining ;
} ;


class CDrops  
{
public:
	CPtrList	m_Drops ;
	CPtrList	m_DropsValid ;
	CPtrList	m_DropsUber ;
	int			m_NumValidItems ;
	int			m_NumValidUbers ;

	BOOL		m_PreventSpam ;

	int			m_LagPerYard ;
	int			m_DelayTime ;
	int			m_ColorLag ;

	DWORD		m_PlayerX ;
	DWORD		m_PlayerY ;


	CDrops();
	virtual ~CDrops();


	int GetRange(DWORD itemX, DWORD itemY) ;
	int GetClockPos(DWORD itemX, DWORD itemY) ;
	void GetPosFromMem() ;
	void UpdateRange(BOOL fromMovement) ;
	void PickUpItem() ;
	void PickUpUber() ;
};

#endif // !defined(AFX_DROPS_H__0DE5BE25_A1A3_4FA3_BC8F_128F194D958A__INCLUDED_)
